using ConnectorLib.JSON;
using PugMod;
using QFSW.QC;
using Unity.Mathematics;
using Unity.NetCode;
using UnityEngine;

namespace CrowdControl.Delegates.Effects.Implementations
{
    [Effect(
        "spawn_randomBoss",
        // Enemy group 1
        "spawn_acidLarva",
        "spawn_aggressiveSlimeBlob",
        "spawn_mushroomEnemy",
        // Enemy group 2
        "spawn_bigLarva",
        "spawn_royalSlimeBlob",
        "spawn_slipperySlimeBlob",
        "spawn_poisonSlimeBlob",
        // Enemy group 3
        "spawn_lavaSlimeBlob",
        "spawn_cavelingSkirmisher",
        // Enemy group 4
        "spawn_cavelingSpearman",
        "spawn_caveling",
        "spawn_cavelingShaman",
        "spawn_cavelingBrute",
        "spawn_cavelingGardener",
        "spawn_cavelingHunter",
        "spawn_infectedCaveling",
        "spawn_cavelingScholar",
        // Enemy group 5
        "spawn_cavelingAssassin",
        "spawn_cavelingMummy",
        // Enemy group 6
        "spawn_ghostScholar",
        "spawn_ancientGolem",
        "spawn_orbitalTurret",
        // Enemy group 7
        "spawn_clayWormSegment",
        "spawn_wormSegment",
        "spawn_mimite",
        "spawn_bombScarab",
        // Enemy group 8
        "spawn_slimeBoss",
        "spawn_kingSlime",
        "spawn_poisonSlimeBoss",
        "spawn_lavaSlimeBoss",
        // Enemy group 9
        "spawn_shamanBoss",
        "spawn_birdBoss",
        "spawn_scarabBoss",
        "spawn_hydraBossNature",
        "spawn_hydraBossSea",
        "spawn_hydraBossDesert",
        "spawn_snakeBossSegment",
        "spawn_larvaHiveHalloweenBoss",
        // Enemy group 10
        "spawn_amoebaWormSegment",
        "spawn_amoebaGiantSegment",
        "spawn_coreBoss"
        )]
    public class Spawn : Effect
    {
        public Spawn(CrowdControl mod, NetworkClient client) : base(mod, client) { }
        
        private static void InstantiateObject(int objectID, int variation, float3 position)
        {
            /*if (API.Server.World.IsServer())
                API.Server.InstantiateObject(objectID, variation, position);
            else*/
                SendChatCommand($"chat cc_spawn {objectID} {position.x} {position.y} {position.z}");
        }
        
        private static void SendChatCommand(string command)
        {
            Debug.Log($"Sending chat command: {command}");
            QuantumConsole console = Object.FindObjectOfType<QuantumConsole>();
            console.InvokeCommand(command);
        }
        
        public override EffectResponse Start(EffectRequest request)
        {
            if (API.Client.LocalPlayer == null)
                return EffectResponse.Failure(request.ID, StandardErrors.PlayerNotFound);

            Vector3 position = API.Client.LocalPlayer.transform.position - API.Rendering.RenderOffset;
            
            string[] codeParams = request.code.Split('_');
            if (codeParams.Length < 2)
                return EffectResponse.Failure(request.ID, StandardErrors.BadRequest, "Invalid effect code format.");
            
            switch (codeParams[1])
            {
                // Enemy group 1
                case "acidLarva":
                {
                    InstantiateObject((int)ObjectID.AcidLarva, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "aggressiveSlimeBlob":
                {
                    InstantiateObject((int)ObjectID.AggressiveSlimeBlob, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "mushroomEnemy":
                {
                    InstantiateObject((int)ObjectID.MushroomEnemy, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 3
                case "bigLarva":
                {
                    InstantiateObject((int)ObjectID.BigLarva, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "royalSlimeBlob":
                {
                    InstantiateObject((int)ObjectID.RoyalSlimeBlob, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "slipperySlimeBlob":
                {
                    InstantiateObject((int)ObjectID.SlipperySlimeBlob, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "poisonSlimeBlob":
                {
                    InstantiateObject((int)ObjectID.PoisonSlimeBlob, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 5
                case "lavaSlimeBlob":
                {
                    InstantiateObject((int)ObjectID.LavaSlimeBlob, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingSkirmisher":
                {
                    InstantiateObject((int)ObjectID.CavelingSkirmisher, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 8
                case "cavelingSpearman":
                {
                    InstantiateObject((int)ObjectID.CavelingSpearman, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "caveling":
                {
                    InstantiateObject((int)ObjectID.Caveling, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingShaman":
                {
                    InstantiateObject((int)ObjectID.CavelingShaman, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingBrute":
                {
                    InstantiateObject((int)ObjectID.CavelingBrute, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingGardener":
                {
                    InstantiateObject((int)ObjectID.CavelingGardener, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingHunter":
                {
                    InstantiateObject((int)ObjectID.CavelingHunter, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "infectedCaveling":
                {
                    InstantiateObject((int)ObjectID.InfectedCaveling, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingScholar":
                {
                    InstantiateObject((int)ObjectID.CavelingScholar, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 13
                case "cavelingAssassin":
                {
                    InstantiateObject((int)ObjectID.CavelingAssassin, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "cavelingMummy":
                {
                    InstantiateObject((int)ObjectID.CavelingMummy, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 30
                case "ghostScholar":
                {
                    InstantiateObject((int)ObjectID.GhostScholar, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "ancientGolem":
                {
                    InstantiateObject((int)ObjectID.AncientGolem, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "orbitalTurret":
                {
                    InstantiateObject((int)ObjectID.OrbitalTurret, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 50
                case "clayWormSegment":
                {
                    InstantiateObject((int)ObjectID.ClayWormSegment, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "wormSegment":
                {
                    InstantiateObject((int)ObjectID.WormSegment, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "mimite":
                {
                    InstantiateObject((int)ObjectID.Mimite, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "bombScarab":
                {
                    InstantiateObject((int)ObjectID.BombScarab, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 75
                case "slimeBoss":
                {
                    InstantiateObject((int)ObjectID.SlimeBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "kingSlime":
                {
                    InstantiateObject((int)ObjectID.KingSlime, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "poisonSlimeBoss":
                {
                    InstantiateObject((int)ObjectID.PoisonSlimeBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "lavaSlimeBoss":
                {
                    InstantiateObject((int)ObjectID.LavaSlimeBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 100
                case "shamanBoss":
                {
                    InstantiateObject((int)ObjectID.ShamanBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "birdBoss":
                {
                    InstantiateObject((int)ObjectID.BirdBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "scarabBoss":
                {
                    InstantiateObject((int)ObjectID.ScarabBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "hydraBossNature":
                {
                    InstantiateObject((int)ObjectID.HydraBossNature, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "hydraBossSea":
                {
                    InstantiateObject((int)ObjectID.HydraBossSea, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "hydraBossDesert":
                {
                    InstantiateObject((int)ObjectID.HydraBossDesert, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "snakeBossSegment":
                {
                    InstantiateObject((int)ObjectID.SnakeBossSegment, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "larvaHiveHalloweenBoss":
                {
                    InstantiateObject((int)ObjectID.LarvaHiveHalloweenBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                // Enemy group 180
                case "amoebaWormSegment":
                {
                    InstantiateObject((int)ObjectID.AmoebaWormSegment, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "amoebaGiantSegment":
                {
                    InstantiateObject((int)ObjectID.AmoebaGiantSegment, 0, position);
                    return EffectResponse.Success(request.ID);
                }
                case "coreBoss":
                {
                    InstantiateObject((int)ObjectID.CoreBoss, 0, position);
                    return EffectResponse.Success(request.ID);
                }

                default:
                    return EffectResponse.Failure(request.ID, StandardErrors.EffectUnknown);
            }
        }
    }
}